#pragma rtGlobals=1		// Use modern global access method.


Menu "Hot Spots"
"Square ROI machine"
"Three layers ROI machine"
"Square ROI auto processing"
"Search local maximum"
"Plot ROI trace"
"Plot 3D hotspot average"
"-"
"Image shift"
"Create an averaged rest frame"
"image DF"
"image DF over Fo"
"-"
"Ribbon Spots"
"ribbonspotsnearby"
"Ca Spots"
"-"
"Create the reference"
"Calculate the cylidral spot"
end

Proc Searchlocalmaximum()
  
  Maxfinder()

End

Window RibbonSpots() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(652,67,942,122)
	Button SinglePixel,pos={4,10},size={280,34},proc=ribbonspot,title="get ribbon profile"
	Button SinglePixel,labelBack=(65280,32512,16384),fSize=16,fStyle=1
EndMacro
 
Window ribbonspotsnearby() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(652,67,942,122)
	Button SinglePixel,pos={4,10},size={280,34},proc=ribbonspotsnearby,title="get ribbon nearby profile"
	Button SinglePixel,labelBack=(65280,32512,16384),fSize=16,fStyle=1
EndMacro

Window SquareROIAutoProcessing() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(652,67,942,122)
	Button SinglePixel,pos={4,10},size={280,34},proc=GetPixelinfo,title="Create ROI !"
	Button SinglePixel,labelBack=(65280,32512,16384),fSize=16,fStyle=1
EndMacro
 

Window squareROImachine() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(652,67,942,122)
	Button SinglePixel,pos={4,10},size={280,34},proc=SinglePixel,title="Create ROI !"
	Button SinglePixel,labelBack=(65280,32512,16384),fSize=16,fStyle=1
	Button SpotND,pos={7,13},size={36,29},proc=SpotND,title=" same\rspot"
	Button SpotND,fColor=(13056,13056,13056)
EndMacro

Proc Plot3Dhotspotaverage(centralayer,NoS)
	variable centralayer, NoS
	Prompt Nos,"No. of the spot"
	Prompt centralayer,"the central layer of this spot"
	VolumeAverage(NoS,CentraLayer)
end

Proc ThreeLayersROImachine(centralayer)
	variable centralayer
	Prompt centralayer,"the central layer of this spot"
	ImagePopup(centralayer)
end

Proc PlotROItrace(Folder,Mask,F_int,ini_n,n,key)
	VARIABLE F_int,n,ini_n
	STRING Mask,key,folder
	Prompt Folder,"Select the specified folder",popup,ListFolder()
	Prompt Mask,"Enter the name of ROI mask"
	Prompt F_int,"Frame Interval"
	Prompt ini_n,"From which ROI"
	Prompt n,"requested numbers of spot under this mask name (Format: Mask_No.) " 
	Prompt key,"The indexed keyword of waves to be ploted"
	PlotROI(Mask,F_int,Folder,ini_n,n,key)
end

Proc Createanaveragedrestframe(Start,Final,key)
	VARIABLE Start,Final
	STRING Key
	Prompt Start,"No. of first frame"
	Prompt Final,"No. of final frame"
	Prompt key,"keyword of the target waves"
	AvgFrame(Start,Final,key,"")
end

//

Proc ImageDF(BGWaves,Keyword)
	STRING BGWaves,keyword
	Prompt BGWaves,"select the rest frame(Fo )", popup, wavelist("*",";","")
	prompt keyword,"sharing keywords of subtracting waves"
	RestSubtract(BGWaves,Keyword)
end

Proc ImageDFoverFo(BGWaves,keyword)
	STRING BGWaves,keyword
	Prompt BGWaves,"select the rest frame(Fo)", popup, wavelist("*",";","")
	prompt keyword,"sharing keywords of subtracting waves"
	BGSubtract(BGWaves,Keyword)
end

Proc ImageShift(dX,dY,Image,key)
	VARIABLE dX,dY
	STRING key="",Image="All by key;"+wavelist("*",";","")
	Prompt dX,"Shift pixel numbers in X  (Right:+, Left:-)"
	Prompt dY,"Shift pixel numbers in Y (Down:+, Up:-)"
	Prompt Image,"Specify one image", popup, Image
	Prompt Key, "Select all waves corresponding to the keyword"
	
	imagemoving(dX,dY,Image,key)
		
end

//

function Imagemoving(dX,dY,Image,key)
	VARIABLE dX,dY
	string Image,key
	variable Xi,Yi,Xn,Yn,i
	
	if(Stringmatch(image,"All by key") == 1)
		Image = Wavelist(key,";","")
		variable waveno= ItemsInList(Image,";")
	else
	endif
	
	if(dX >=0 )
		Xi= dX
	else
		Xi=0
	endif
	
	if(dY >=0 )
		Yi= dY
	else
		Yi=0
	endif
	
	For(i=0;i<waveno;i+=1)
		Wave ImageWave=$stringfromlist(i,Image,";")
		make/O/n=(dimsize(ImageWave,0)+abs(dX),dimsize(ImageWave,1)+abs(dY)) TempImage
		Redimension/S TempImage
		For(Xn=0;Xn<dimsize(ImageWave,0);Xn+=1)
			For(Yn=0;Yn<dimsize(ImageWave,1);Yn+=1)
				TempImage[Xn+Xi][Yn+Yi] = ImageWave[Xn][Yn]
			endfor
		endfor
		KillWaves ImageWave
		Rename TempImage, $stringfromlist(i,Image,";")
	endfor	
end



Proc Createthereference(Ori,bottom,Vq)
	variable Ori,bottom,Vq
	Prompt Ori,"Enter the coordinate of origin"
	Prompt bottom,"Enter the coordinate of bottom"
	Prompt Vq,"Enter the vector of stereocilia (point toward base)"
	Wave Vz = bottom-Ori
end


Proc Calculatethecylidralspot(X_Off,Y_Off)
	VARIABLE X_Off,Y_Off
	Prompt X_Off,"Offset of X coordinate (after frame moving, the new position of origin(0,0))"
	Prompt Y_Off,"Offset of Y coordinate (after frame moving, the new position of origin(0,0))"
	Wave spots
	CylindCalcX(spots,X_Off,Y_Off)
end


Function SinglePixel(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
       
      case 2: // mouse up
      		SetSinglePixelROI()
//     	DoWindow/K SquareROImachine
//     		DoWindow/K $winname(0,1)
	break
	endswitch

	return 0
	
 End
 
Function SpotND(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			DFREF home=getdatafolderdfr()
			SetDatafolder Root:
			NVAR/Z SpotN
			SpotN=SpotN-1
			SetDataFolder home
			break
	endswitch

	return 0
End
 
 Function SetSinglePixelROI()
       
       DFREF home=GetDataFolderdfr()
       VARIABLE X,Y
       X=pcsr(A)-1
       Y=qcsr(A)-1
       SetDataFolder Root:
       NVar/Z SpotN
       if(NVar_Exists(SpotN)==0)
       	Variable/G SpotN=1
       else
             SpotN=SpotN+1
       endif
      setdatafolder home
      
      STRING ImageName=WMTopImageName()
      wave w=ImageNameToWaveRef(WMTopImageGraph(),ImageName)
      DFREF ImageFolder = GetWavesDataFolderDFR(w)
//      print imagefolder
      setdatafolder ImageFolder
      
       
      String ROI_Spot = "Spot"
      String ROI_Rect = "Square9_" 
      	String ROI_Mask1= ROI_Spot+num2str(SpotN)
      	String ROI_Mask2= ROI_Rect+num2str(SpotN)      	
	String ImGrfName= WMTopImageGraph()
	if( strlen(ImGrfName) == 0 )
		return 0
	endif
	
	DoWindow/F $ImGrfName
	SetDrawLayer ProgFront
	Wave w= $WMGetImageWave(ImGrfName)		// the target matrix
	Variable D=DimDelta(w,0)
	String iminfo= ImageInfo(ImGrfName, NameOfWave(w), 0)
	String xax= StrINGByKey("XAXIS",iminfo)
	String yax= StringByKey("YAXIS",iminfo)
	SetDrawEnv linefgc= (3,52428,1),fillpat= 0,xcoord=$xax,ycoord=$yax,save
       DrawRect X*D,Y*D,X*D+D,Y*D+D
             
	GraphNormal
	SetDrawLayer UserFront
	
	if (Waveexists($ROI_Mask1)==1)
		killwaves $ROI_Mask1
		ImageGenerateROIMask/E=1/I=0 $WMTopImageName()
		Rename M_ROIMask $ROI_Mask1
	else
		ImageGenerateROIMask/E=1/I=0 $WMTopImageName()
		Rename M_ROIMask $ROI_Mask1
	endif
	
	wave w=$ROI_Mask1
	note $NameOfWave(w), WMGetImageWave("")
      
      	GraphNormal
	SetDrawLayer/K ProgFront
	SetDrawLayer UserFront
	
	DoWindow/F $ImGrfName
	SetDrawLayer ProgFront
	SetDrawEnv linefgc= (3,52428,1),fillpat= 0,xcoord=$xax,ycoord=$yax,save
       Drawrect (X*D)-D,(Y*D)-D,(X*D)+2*D,(Y*D)+2*D
             
	GraphNormal
	SetDrawLayer UserFront
	
	if (Waveexists($ROI_Mask2)==1)
		killwaves $ROI_Mask2
		ImageGenerateROIMask/E=1/I=0 $WMTopImageName()
		Rename M_ROIMask $ROI_Mask2
	else
		ImageGenerateROIMask/E=1/I=0 $WMTopImageName()
		Rename M_ROIMask $ROI_Mask2
	endif
	
	GraphNormal
	SetDrawLayer/K ProgFront
	SetDrawLayer UserFront
	
	SetDataFolder home
 end
 
 Function F0pickup()
 // this function will pick up the F0 value on the pixels which are showed on the output profile wave "spots". 
 // the image wave which is used is the raw_depolarized stacks.
 	setdatafolder :ZStack_Rest
 	wave ZStack_Rest
 	string folderadress1 = getdatafolder(1)
 	setdatafolder root:working_folder:spots
 	wave spots
 	setdatafolder $folderadress1
 	variable i,X,Y,Z
 	make/n=(dimsize(spots,0)) F0
 	for(i=0;i<dimsize(spots,0);i+=1)
 		X=spots[i][2]
 		Y=spots[i][3]
 		Z=spots[i][4]
 		F0[i]=ZStack_Rest[X][Y][Z]
 	endfor
 	concatenate/np=1 {F0},Spots
 	
 	NewPath currentfolder
 	save/I/P=currentfolder Spots  
 end
 
 Function MaxFinder()
// This program is designed for looking for the maxium pixel close to the region of selected, 
// and output the position (X,Y,Z) and its intensity
	
	VARIABLE/G J
	
	Variable X,Y
	Variable X_Ori,Y_Ori
	Variable Z
	Variable R,n=0,i,q=0,K
	String ImGrfName = WMTopImageName()
	Wave w = $WMTopImageName()
	Wave ZStack_DFR
	X_Ori= pcsr(A)
	Y_Ori= qcsr(A)
	Z= Zcsr(A)
	
	// This loop trys to find the Z layer of the current Image, but their is a potential bug exsiting
	// The strategy is finding the same intensity value on the same position of X,Y through Z, so
	// if there is the same intensity on another layers, it will go to the wrong layer. 
	For(n=0;n<=39;n+=1)
		if( w[X_Ori][Y_Ori][n] == Z)
			break
		else
		Endif	
	Endfor
	// End of description
	
	NVAR/Z J
	
	if(NVar_exists(J)==0)
		J=1
	Else
		J=J+1
	Endif
	
	String Wave1 = "Rwave_"+num2str(J)
	String Wave2 = "Spot_"+num2str(J)
	
	Make Rwave
	Make IWave
	Make/O/n=(1,7) TempSpot
//	If (Waveexists(Spots)!=1)
//		Make/n=(1,7) spots
//	Else
//		Wave spots
//	endif
	
	i=n
	K=n
	
	ImageStats/P=(K)/G={X_Ori-1,X_Ori+1,Y_Ori-1,Y_Ori+1} $ImGrfName
	make/O/n=(10,3) Lwave
	For(i=K;i<=K+9;i+=1)
		if(V_Max<=30)
			if(i-K<=6)
				K=K+1
				ImageStats/P=(K)/G={X_Ori-1,X_Ori+1,Y_Ori-1,Y_Ori+1} $ImGrfName
			else
				Break
			endif
		Else
			Do
				X=V_MaxRowLoc
				Y=V_MaxColLoc
				ImageStats/P=(i)/G={X-1,X+1,Y-1,Y+1} $ImGrfName
			While(V_MaxColLoc != Y || V_MaxRowLoc != X)
			if(i-K == 0)
				X_Ori=X
				Y_Ori=Y
				Lwave[i-K][0]=X
				Lwave[i-K][1]=Y
				Lwave[i-K][2]=n+i-K
				Rwave[i-K]=R
				Iwave[i-K]= V_Max
			Else
				Print X,Y,V_Max
				R= sqrt((0.164*(X-X_Ori))^2+(0.164*(Y-Y_Ori))^2+(0.5*(i-n))^2)
				Lwave[i-K][0]=X
				Lwave[i-K][1]=Y
				Lwave[i-K][2]=n+i-K
				Rwave[i-K]=R
				Iwave[i-K]= V_Max
			Endif
		Endif
	Endfor	
	
		Deletepoints/M=0 i-K,128,Rwave,Iwave
		
		Duplicate RWave, $Wave1
		Duplicate IWave, $Wave2
		
		Killwaves Rwave
		Killwaves Iwave
		
		Curvefit/Q gauss $Wave2 /X=$Wave1/D
		String FitWave="Fit_"+"Spot_"+num2str(J)
		WaveStats/Q $FitWave
		TempSpot[J-1][0]=V_max
		Wavestats $wave2
		TempSpot[J-1][2]=Lwave[V_maxloc][0]
		TempSpot[J-1][3]=Lwave[V_maxloc][1]
		TempSpot[J-1][4]=Lwave[V_maxloc][2]
		TempSpot[J-1][1]=ZStack_DFR[Lwave[V_maxloc][0]][Lwave[V_maxloc][1]][Lwave[V_maxloc][2]]
//		TempSpot[J-1][5]=
//		TempSpot[J-1][6]=
		
		concatenate/np=0 {TempSpot},Spots
		killwaves $Wave2,$Wave1,Lwave
End

Function TextWaveCreator()
	VARIABLE/G J
	
	variable i
	make/T/n=(j) No_Spot
	For(i=1;i<=j;i+=1)
		No_Spot[j]="Spot_"+num2str(j)
	Endfor

End

Function/Wave PlotThisROI(Rmask,F_Int,FolderName,Keyword)
	string Rmask,FolderName,keyword
	variable F_int
	
	DFREF home=getdatafolderdfr()
    	if(stringmatch(foldername,"")!=1)
       	setdatafolder $FolderName
    	else
    		Doalert 0,"This folder dosen't exist."
    		return nan
    	endif	
	
	string Allname=Wavelist(keyword,";","")
    	string filename
    	variable j
    	
    	Make/O/N=(ItemsInList(AllName)) Avg_S
     	for(j=0;j<ItemsInList(AllName);j+=1)
    		FileName = StringFromList(j, AllName)
    	 	ImageStats/R=$Rmask $FileName
    	 	Avg_S[j] = V_avg
     	endfor
	SetScale/P x 0,F_int, Avg_S
	return Avg_S
end

 Function/Wave PlotROIZ(ROIMaskName,ini_n,n,FileName)
    	
    	STRING ROIMaskName,FileName
    	VARIABLE n,ini_n           //tell Igor how many spot will be analyzed
    	
    	
    	string NewName,RName
    	STRING AllROI=wavelist(ROIMaskName,";","")
    	string cmd
    	String RoiName
    	VARIABLE j,k    
    
	wave BG=FoMinus(1,4,$FileName)
    	
    	VARIABLE i=DimSize($FileName,2)
    	variable SG,Vbg 

    
     	for(k=0;k<n;k+=1)
     	      RoiName= StringFromList(k+ini_n-1,AllROI,";")
     	      Make/O/N=(i) Avg_S
//     	Make/O/N=(i) Ratio_S
     		for(j=0;j<i;j+=1)
    	 		ImageStats/P=(j)/R=$ROIName $FileName    	 		
    	 		SG=V_avg
//   	 		ImageStats/R=$ROIName BG
//  	 		Avg_S[j] = SG-V_avg
			Avg_S[j] = SG	 		
//    	 		Ratio_S[j]=(SG-V_avg)/(V_avg)
     		endfor
		NewName="Avg_"+ROIName
		Rname="Ratio_"+ROIName
   	      Rename Avg_S, $NewName
//   	      rename Ratio_S, $RName
     	endfor
     	killwaves BG
     // 2.on checkbox for filtering is also needed, perhaps a special box for filtering.
	return $NewName
	setdatafolder home			
 //       display $ROIName+"_Avg"
 
 End


 Function/Wave PlotROI(ROIMaskName,F_Int,FolderName,ini_n,n,keyword)
    	
    	STRING ROIMaskName,Keyword,FolderName
    	VARIABLE F_Int     // tell Igor the scale
    	VARIABLE n,ini_n           //tell Igor how many spot will be analyzed
    	
    	DFREF home=getdatafolderdfr()
    	if(stringmatch(foldername,"")!=1)
       	setdatafolder $FolderName
    	else

    	endif
    	
    	STRING AllName
    	STRING FileName
    	string NewName
    	STRING AllROI=wavelist(ROIMaskName,";","")
    	string cmd
    	String RoiName
    	VARIABLE j,k    
    
	
    	Allname=Wavelist(keyword,";","")
    	VARIABLE i= ItemsInList(AllName)
    
     	for(k=0;k<n;k+=1)
     	      RoiName= StringFromList(k+ini_n-1,AllROI,";")
     	      print StringFromList(k+ini_n-1,AllROI,";")
     	      Make/O/N=(i) Avg_S
     		for(j=0;j<i;j+=1)
    			FileName = StringFromList(j, AllName)
    	 		ImageStats/R=$ROIName $FileName
    	 		Avg_S[j] = V_avg
     		endfor
     		// 1.setscale , one column for frame interval is needed
		SetScale/P x 0,F_int, Avg_S
//     	print cmd
//   	      Execute cmd
//     	movewave Avg_S, home
		NewName=ROIName+"_Avg"
   	      Rename Avg_S, $NewName     		
     	endfor
     // 2.on checkbox for filtering is also needed, perhaps a special box for filtering.
	return $NewName
	setdatafolder home			
 //       display $ROIName+"_Avg"
 
 End

//Function CreateNewZ(Ori,Bottom)
	//WAVE Ori, Bottom
	//Make Vz= Ori-Bottom
	Vz[0] = Vz[0]*0.164
	Vz[1] = Vz[1]*0.164
	Vz[2] = Vz[2]*0.5	
End



Function/wave AvgFrame(StartX, EndX,keyword,Name)
	
	VARIABLE StartX, EndX
	STRING Keyword,Name
	
	String AvgName
	String AllName

	
	if( stringmatch(Name,"")==0)
		AvgName = Name 				
	else
		AvgName="AvgFrm"+num2str(StartX)+"to"+num2str(EndX)
	endif 

	VARIABLE j


	Allname=Wavelist(Keyword,";","" )
	wave w=$stringfromlist(0,AllName)
	
	make/O/n=(DimSize(w,0),DimSize(w,1)) AvgFrm
	For (j=StartX; j<=EndX; j+=1)
	
		Duplicate/O $stringfromlist(j,AllName), Image 
       		AvgFrm = AvgFrm + Image       			
       Endfor
       	AvgFrm=AvgFrm/(EndX-StartX+1)
       	killwaves/Z Image
       	rename AvgFrm, $Name
       	wave w=$Name
//       	rename AvgFrm,  $AvgName
       	Return w

End


Function Restsubtract(BackGroundWave,key)
	STRING BackGroundWave,key
	wave w= $BackGroundWave
	Duplicate/O w,BGWave
	Redimension/S tempWave

	string AllWaves=wavelist(key,";","")
	variable i
	
	NewDataFolder DeltaF
	for(i=0;i<itemsinlist(Allwaves);i+=1)
		Wave tempwave = $stringfromlist(i,Allwaves,";")
		redimension/S tempwave
		make/O/n=(dimsize(TempWave,0),dimsize(TempWave,1)) new
		new = tempwave-BGWave		
		movewave new, :DeltaF:$StringFromList(i,Allwaves,";")			
	endfor
	killwaves new,NewWave,BGWave
	
end

Function GetDFoF0()
	String allwaves=wavelist("*",";","")
	variable i
	for(i=0;i<itemsinlist(allwaves);i+=1)
		concatenate/np=0 {$stringfromlist(i,allwaves,";")}, SpotsPool
	endfor
	
	make/n=(dimsize(SpotsPool,0)) DFoF0
	for(i=0;i<dimsize(SpotsPool,0);i+=1)
		DFoF0[i]=SpotsPool[i][1]/SpotsPool[i][17]
	endfor
	
	concatenate/np=1 {DFoF0},SpotsPool
end

Function OverallFrSubt()
	string FolderList=ListFolder()
	string RestWave
	DFREF home=getdatafolderdfr()
	NVAR/Z K
	variable i
	for(i=0;i<K;i+=1)
		setdatafolder $stringfromlist(i,FolderList)
		RestWave="AvgRest"+num2str(i)
		Restsubtract(RestWave,"Slice*")
		setdatafolder home
	endfor
end


// plot the averaged traces of 27 voxels according to the ROIs.
Function VolumeAverage(NoS,CLayer)
	VARIABLE NoS, CLayer
	
	DFREF home=GetDataFolderdfr()
	String ROIN="9_"+num2str(NoS)
	String Folder="Slice"+num2str(CLayer-1)
	String SpotName="Spot"+num2str(Nos)
	String ImageName,FileName,RestName
	variable j
	
	SetDataFolder Root:
	
	NVAR SpotN
	if(NVAR_Exists(SpotN)!=1)
		Variable/G SpotN=1
//	elseif(NVAR_Exists(SpotN)==1)
//		SpotN=SpotN+1
	endif
	
	setdatafolder home	
	NewDataFolder/O/S CaTraces
	newdatafolder/S $SpotName
	DFREF Target=getdatafolderdfr()
	
	
	if(CLayer-1>=0)
		SetDataFolder home:$Folder 
//		RestName="AvgRest"+num2str(CLayer-1)
		RestName=stringfromlist(0,wavelist("AvgRest*",";",""))
		ImageName=wavelist("Slice*",";","")
	 
	 
		make/O/n=(ItemsInList(ImageName)) ROISum
		for(j=0;j<ItemsInList(ImageName);j+=1)
    			FileName = StringFromList(j, ImageName)
			ImageStats/R=$ROIN $FileName
    	 		ROISum[j] = V_avg*V_npnts
    	 		ImageStats/R=$ROIN $RestName
    	 		ROISum[j] = ROISum[j]-V_avg*V_npnts
     		endfor
     		movewave ROISum, home
     		setdatafolder home
     		Folder = "Slice"+num2str(CLayer)
     		wave Avg_S=PlotThisROI(ROIN,0.005,Folder,"Slice*")		
//     	setdatafolder home:$Folder
     	else
     		setdatafolder home
     		Folder = "Slice"+num2str(CLayer)
     		wave Avg_S=plotROI(ROIN,0.005,Folder,0,1,"Slice*")		
		setdatafolder :$Folder
     		ImageName=wavelist("Slice*",";","")	 
		make/O/n=(ItemsInList(ImageName)) ROISum
		
     	endif
     	
	
	
//	movewave $ROIN, :DeltaF 
//	movewave ROISum, DeltaF
//	setdatafolder DeltaF
//	RestName="AvgRest"+num2str(CLayer)
	RestName=stringfromlist(0,wavelist("AvgRest*",";",""))	
	ImageName=wavelist("Slice*",";","")
	for(j=0;j<ItemsInList(ImageName);j+=1)
    		FileName = StringFromList(j, ImageName)
		ImageStats/R=$ROIN $FileName
    	 	ROISum[j] =ROISum[j]+ V_avg*V_npnts
        	ImageStats/R=$ROIN $RestName
    	 	ROISum[j] = ROISum[j]-V_avg*V_npnts
    	 	Avg_S[j]=Avg_S[j]-V_avg
     	endfor
	movewave Avg_S,Target
	movewave ROISum, home
	
	setdatafolder home
	Folder = "Slice"+num2str(CLayer+1)

	
	setdatafolder :$Folder
//	movewave $ROIN, :DeltaF 
//	movewave ROISum, DeltaF
//	setdatafolder DeltaF
//	RestName="AvgRest"+num2str(CLayer+1)
	RestName=stringfromlist(0,wavelist("AvgRest*",";",""))
	ImageName=wavelist("Slice*",";","")
	 
	for(j=0;j<ItemsInList(ImageName);j+=1)
    		FileName = StringFromList(j, ImageName)
		ImageStats/R=$ROIN $FileName
    	 	ROISum[j] =ROISum[j]+ V_avg*V_npnts
    	 	ImageStats/R=$ROIN $RestName
    	 	ROISum[j] = ROISum[j]-V_avg*V_npnts
     	endfor

	ROISum=ROIsum/27
	
	
	movewave ROISum, Target
	setdatafolder Target
	string SingleName="Avg_"+num2str(NoS)
	Rename ROISum, $SingleName
	
	setdatafolder home

End

Function ImagePopup(CLayer)
	Variable CLayer
	
	DFREF home=GetDataFolderdfr()
	string cmd
	String Folder="Slice"+num2str(CLayer-1)
	String ImageName
	SetDataFolder Root:
	NVAR/Z SpotN
//	if(NVAR_Exists(SpotN)!=1)
//		Variable/G SpotN=1
//	elseif(NVAR_Exists(SpotN)==1)
//		SpotN=SpotN+1
//	endif

	SetDataFolder home
	SetDataFolder $Folder
	ImageName=stringfromlist(0,wavelist("davgdep*",";",""))
	NewImage $ImageName
	ModifyImage $ImageName ctab= {10,*,Geo32,0}
	SetDataFolder home
	Folder = "Slice"+num2str(CLayer)
	SetDataFolder $Folder
	ImageName=stringfromlist(0,wavelist("davgdep*",";",""))
	NewImage $ImageName
	ModifyImage $ImageName ctab= {10,*,Geo32,0}
	SetDataFolder home
	Folder = "Slice"+num2str(CLayer+1)
	SetDataFolder $Folder
	ImageName=stringfromlist(0,wavelist("davgdep*",";",""))
	NewImage $ImageName
	ModifyImage $ImageName ctab= {10,*,Geo32,0}
	
	SetDataFolder home

end


function WholeCellPlot()
	DFREF home=getdatafolderdfr()
	setdatafolder Root:
	NVAR spotN
	
	setdatafolder Working_Folder
	NewDataFolder/S CaTraces
	DFREF Target=getdatafolderdfr()
	setdatafolder home

end

function RibbonSpot(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
       
      case 2: // mouse up	
//		if(waveexists(RbProfile)!=1)
//			make/n=4 Rbprofile
//		else
//			wave RbProfile
//		endif
	
		DFREF home=getdatafolderdfr()
		wave Image=ImageNameToWaveRef(WMTopImageGraph(),WMTopImageName())
		setscale/P x,0,0.103, Image
		setscale/P y,0,0.103, Image
		setscale/P z,0,0.5, Image

	//	DFREF ImageFolder=GetWavesDataFolderDFR(Image)
	//	setdatafolder
	
		make/n=(1,4) OneRb
		OneRb[0][1]=xcsr(A)
		OneRb[0][2]=vcsr(A)
	
		controlinfo/W=$WMTopImageGraph() WM3DVal
		OneRb[0][3]=V_Value*DimDelta(Image,2)

		OneRb[0][0]=zcsr(A)
		concatenate/KILL/NP=0 {OneRb}, RbProfile
		
		break
	endswitch
	
	return 0
	
end

//function ribbonspotsnearby(ba) : ButtonControl
	//STRUCT WMButtonAction &ba

	switch( ba.eventCode )
       
      case 2: // mouse up	
//		if(waveexists(RbProfile)!=1)
//			make/n=4 Rbprofile
//		else
//			wave RbProfile
//		endif
	
		DFREF home=getdatafolderdfr()
		wave Image=ImageNameToWaveRef(WMTopImageGraph(),WMTopImageName())
		setscale/P x,0,0.103, Image
		setscale/P y,0,0.103, Image
		setscale/P z,0,0.5, Image

	//	DFREF ImageFolder=GetWavesDataFolderDFR(Image)
	//	setdatafolder
	
		make/n=(1,4) OneRb
		OneRb[0][1]=xcsr(A)
		OneRb[0][2]=vcsr(A)
	
		controlinfo/W=$WMTopImageGraph() WM3DVal
		OneRb[0][3]=V_Value*DimDelta(Image,2)

		OneRb[0][0]=zcsr(A)
		concatenate/KILL/NP=0 {OneRb}, RbProfile_nearby
		
		break
	endswitch
	
	return 0
	
end

function distance(A,B)
	string A,B
	
	wave w1=$A
	wave W2=$B
	
	variable r=sqrt((w1[0]-w2[0])^2+(w1[1]-w2[1])^2+(w1[2]-w2[2])^2)
	print r
	
end


Function CaSpot(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			DFREF home=getdatafolderdfr()
			wave Image=ImageNameToWaveRef(WMTopImageGraph(),WMTopImageName())
//			setscale/P x,0,0.104, Image
//			setscale/P y,0,0.104, Image
//			setscale/P z,0,0.5, Image

		//	DFREF ImageFolder=GetWavesDataFolderDFR(Image)
		//	setdatafolder
			make/n=(1,5) OneCa
			OneCa[0][2]=xcsr(A)
			OneCa[0][3]=vcsr(A)
	
			controlinfo/W=$WMTopImageGraph() WM3DVal
			OneCa[0][4]=V_Value*DimDelta(Image,2)
	
			duplicate/R=[0,DimSize(Image,0)][0,DimSize(Image,1)][V_Value,V_Value] Image,currentlayer
			Imagestats/G={pcsr(A)-1,pcsr(A)+1,qcsr(A)-1,qcsr(A)+1} currentlayer
			killwaves currentlayer
			
			OneCa[0][0]=V_avg
			OneCa[0][1]=zcsr(A)
			concatenate/KILL/NP=0 {OneCa}, CaProfile
		case -1: // control being killed
			break
	endswitch

	return 0
End

Window CaSpots() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(916,194,1119,250)
	Button PickUpCa,pos={8,9},size={184,36},proc=CaSpot,title="Calcium spot"
	Button PickUpCa,fSize=16,fStyle=1
EndMacro

function pickupavg()
	
	string allwaves=wavelist("dAvg*",";","")
	controlinfo WM3DVal
	variable layer=V_value
	
	Imagestats/G={pcsr(A)-1,pcsr(A)+1,qcsr(A)-1,qcsr(A)+1} $stringfromlist(layer,allwaves)

	variable value=V_avg
	killvariables/A
	
	if(waveexists(CaInt)==0)
		make/n=0 CaInt
	else
		wave CaInt
	endif
	
	insertpoints DimSize(CaInt,0),1,CaInt
	CaInt[DimSize(CaInt,0)-1]=value
end

Function PupImg(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			controlinfo CoL
			variable CLayer=V_Value			
			ImagePopup(CLayer)
			execute "squareROImachine()"
//			execute "squareROImachine()"
//			execute "squareROImachine()"
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

Function FvTracePlot(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			// click code here
			controlinfo CoL
			variable CLayer=V_Value	
			DFREF home=getdatafolderDFR()
			setdatafolder root:
			variable/G spotN
			setdatafolder home
//			NVAR/Z N
//			if(NVAR_Exists(N)!=1)
//				Variable/G N=0
//			endif
//			N=N+1			
			VolumeAverage(SpotN,CLayer)
			RsCorrectVclamper(SpotN,CLayer)
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End




Window Panel2() : Panel
	PauseUpdate; Silent 1		// building window...
	NewPanel /W=(1131,176,1270,269)
	SetVariable CoL,pos={10,7},size={118,16},title="Central layer",value= _NUM:0
	Button PuPimg,pos={9,29},size={118,21},proc=PupImg,title="Images popup"
	Button FVtrace,pos={9,53},size={119,33},proc=FvTracePlot,title="Get FV traces \rfrom 3 layers"
EndMacro

function GetFrest(w)
	wave w
	wave Im=Rest_Stack
	Duplicate/R=[][2,4] w, CaPos
	insertpoints/M=1 1,1,w
	insertpoints/M=1 3,1,w
	variable i,j,k,Px,Py,Pz,avg=0
	for(i=0;i<DimSize(CaPos,0);i+=1)
		Px=CaPos[i][0]/0.164
		Py=CaPos[i][1]/0.164
		Pz=CaPos[i][2]/0.5
		duplicate/O/R=[][][Pz,Pz] Im,currentlayer
		redimension/N=(-1,-1,0) currentlayer		
		for(j=Px-1;j<=Px+1;j+=1)
			for(k=Py-1;k<=Py+1;k+=1)
				avg=avg+currentlayer[j][k]
			endfor
		endfor
		w[i][1]=avg/9
		w[i][3]=w[i][0]/w[i][1]
		avg=0
//		killwaves currentlayer
	endfor
	killwaves CaPos
end

function GoToFolder(n)
	variable n
	
	string F="F"+num2str(n)
	
	DFREF home=getdatafolderDFR()
	
	newdatafolder/S $F
	DFREF CF=getdatafolderDFR()
	
	setdatafolder home
	
	variable i
	string aw=wavelist("*",";","")
	for(i=0;i<ItemsInList(aw);i+=1)
		wave w=$stringfromlist(i,aw)
		movewave w, CF:$NameOfWave(w)
	endfor

end

function SubRegion()

	variable Xo=pcsr(A)
	variable Yo=qcsr(A)
	variable Xe=pcsr(B)
	variable Ye=qcsr(B)
	variable i
	
	wave Im=ImageNameToWaveRef("",WMTopImageName())
	DFREF dest=GetWavesDataFolderDFR(Im)
	setdatafolder dest
	
	string aw=Wavelist("*",";","")
	
	wave ImW=$WMGetImageWave("")
	
	string NewName

	for(i=0;i<ItemsInList(aw);i+=1)
		
		wave w=$stringfromlist(i,aw)
		NewName=cleanupname(NameOfWave(w),0)
		
		if(DimSize(w,0)!=DimSize(ImW,0) || DimSize(w,1)!=DimSize(ImW,1) || DimSize(w,2)!=DimSize(ImW,2))
			continue
		endif
		
		duplicate/O/R=[Xo,Xe][Yo,Ye][] w, Temp
		string Name=NameOfWave(w)
	
		SetScale/P x,0,1,Temp
		SetScale/P y,0,1,Temp
		SetScale/P z,0,0.005,Temp
		
//		killwaves w
		Duplicate/O Temp, $NewName
		
	endfor
	
	killwaves Temp

end

function/WAVE FoMinus(in,fn,w)
	variable in,fn
	wave w
	
//	wave w=$WMGetImageWave("")
	
	variable i
	duplicate/R=[][][in,in] w, BG
	redimension/N=(-1,-1,0) BG
	for(i=in+1;i<=fn;i+=1)
		duplicate/R=[][][i,i] w,Temp
		redimension/N=(-1,-1,0) Temp
		BG=BG+Temp
		killwaves Temp 
	endfor
	
	BG=BG/(fn-in+1)
	
	string NewName=NameOfWave(w)
	NewName= NewName+"_BG"
	rename BG,$NewName
	
	return BG
	
end


//function/Wave DF3D(Ro,Re,So,Se,w)
//	variable Ro,Re,So,Se
//	wave w
//	
//	variable i
//	make/O/n=(DimSize(w,0),DimSize(w,1)) Rest,Stim
//	
//	for(i=Ro;i<=Re;i+=1)
//		duplicate/O/R=[][][i,i] w, temp
//		redimension/N=(-1,-1,0) temp
//		Rest=Rest+temp
//	endfor
//	killwaves temp
//	Rest=Rest/(Re-Ro+1)
//	
//	for(i=So;i<=Se;i+=1)
//		duplicate/O/R=[][][i,i] w, temp
//		redimension/N=(-1,-1,0) temp
//		Stim=Stim+temp
//	endfor
//	killwaves temp
//	Stim=Stim/(Se-So+1)
//	
//	Stim=Stim-Rest
//	
//	return Stim
//
//end
//
//function DF3DALL()
//	string aw=wavelist("*",";","")
//	string NewName
//	
//	variable i
//	for(i=0;i<itemsinlist(aw);i+=1)
//		wave w=$stringfromlist(i,aw)
//		wave Solution=DF3D(1,4,6,9,w)
//		NewName="Image_"+num2str(-70+i*5)
//		rename Solution, $NewName
//	endfor
//
//end

Function GetPixelinfo(ba) : ButtonControl

// Before running this button, make sure the location of your 3D image is in the root folder containig 
// all folders of individual sections

	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
       
      case 2: // mouse up
      		
      		STRING ImageName=WMTopImageName()
      		wave w=ImageNameToWaveRef(WMTopImageGraph(),ImageName)
      		DFREF Home = GetWavesDataFolderDFR(w)
      		SetDataFolder home
      		string HomeName=GetDataFolder(0)

      		
      		SetSinglePixelROI()
//     	DoWindow/K SquareROImachine
//     		DoWindow/K $winname(0,1)
		setdatafolder root:
		variable/G SpotN
		setdatafolder home
		
		controlinfo WM3DAxis
		variable Lr=V_value
		
		string SpotName="Spot"+num2str(SpotN)
		string SquareName="Square9_"+num2str(SpotN)
		string aF=ListFolder()
		
		wave WSpot=$SpotName
		wave WSquare=$SquareName
		
		movewave WSpot, :$StringFromList(Lr,aF):$NameOfWave(WSpot)
		movewave WSquare, :$StringFromList(Lr,aF):$NameOfWave(WSquare)
		setdatafolder $StringFromList(Lr,aF)
		DFREF Dest=GetDataFolderDFR()
		
		string textname="text"+num2str(SpotN)			
		string cmd
		sprintf cmd, "\Z12\\f01\\K(0,65280,0)%g\\B(%g)", SpotN,Lr
		TextBox/F=0/B=1/C/N=$textName cmd
		
		string FolderName
		
		sprintf FolderName,"Root:PatchClamp:%s:%s",HomeName,StringFromList(Lr,aF)
		setdatafolder $FolderName 		
		
		duplicate/O $StringFromList(0,WaveList("VmonSlow_*",";","")), Dest:$StringFromList(0,WaveList("VmonSlow_*",";",""))
		duplicate/O $StringFromList(1,WaveList("VmonSlow_*",";","")), Dest:$StringFromList(1,WaveList("VmonSlow_*",";",""))
		
		SetDataFolder home
		
	break
	endswitch
	
	SetAxis/A/R left
	SetAxis/A top
	
	return 0
	
 End
 
 
 function GetFo(BGwave,DFwave)
 	wave BGwave,DFwave
 	
 	SetScale/P x,0,DimDelta(DFwave,0),BGwave
 	SetScale/P y,0,DimDelta(DFwave,1),BGwave
 	SetScale/P z,0,DimDelta(DFwave,2),BGwave
 	
 	wave BGROI
 	
 	if(waveexists(BGROI)!=1)
 		DoAlert 0,"No Background ROI"
 	endif
 	
 	wave CaProfile
 	variable Xo,Yo,V_Rest,V_BG
	insertpoints/M=1 2,2,CaProfile
 	
 	variable i
 	for(i=0;i<DimSize(CaProfile,0);i+=1)
 		Xo=floor(CaProfile[i][4]/DimDelta(DFwave,0))
 		Yo=floor(CaProfile[i][5]/DimDelta(DFwave,1))		
 		Imagestats/P=(CaProfile[i][6]/DimDelta(DFwave,2))/G={Xo-1,Xo+1,Yo-1,Yo+1} BGwave
 		 V_Rest=V_avg
 		 Imagestats/P=(CaProfile[i][6]/DimDelta(DFwave,2))/R=BGROI BGwave
 		 V_BG=V_avg
		 CaProfile[i][2]=V_Rest-V_BG
		 CaProfile[i][3]=CaProfile[i][0]/CaProfile[i][2]
 	endfor
 	
 
 
 end